.P
For each process, you may create the set of windows shown below:
.DS I N
		Process
    +---------------+----------------+
    |		    |		     |
DATA WINDOWS	CODE WINDOWS	OTHER WINDOWS
------------	------------	-------------
Memory		Assembler	Journal
User Types	Source Files	Signals
Globals		Source Text1	Breakpoints
Frame1		 ...
 ...		Source TextM
FrameN
.DE
.VL 14 1
.LI "Process"
The focal point for examining a process or core dump.
The Process window displays the current status of the program,
and when the program is stopped, a list of all the activation
records (stack frames) on the stack.
The window's menus can be used to open all the other windows
associated with the process, and to start, stop, step, or kill it.
.LI "Source Files"
Lists the files compiled
with the -g option that were used to construct the program.
The line menus allow the Source Text window for each file to be opened.
.LI "Source Text"
These windows are used to display source code,
set and clear breakpoints, and open the Assembler and Frame windows.
Each file listed in the Source Files window has its own Source Text window.
.LI "Assembler"
For viewing assembly code and stepping the processor at the instruction level.
This window can be used to examine the code generated by the compiler,
or to step through functions for which no symbolic debugging information is
available.
.LI "Frame"
Used to examine C data structures in the context of
an activation record.
Each activation record has its own Frame window,
and the menu bar lists the function's local variables and arguments.
The keyboard language allows C expressions to be evaluated and
the line menus provide extensive facilities for formatting data
and traversing data structures.
.LI "Globals"
A Frame window for examining global variables.
Its menu bar lists the global variables.
.LI "Memory"
Allows memory to be examined as unstructured data.
Memory can be viewed as 1 (char), 2 (short), 4 (long, float),
or 8 (double) byte cells and displayed in different formats.
.LI "User Types"
Allows you to examine and control the display
of user defined types.
The menus may be used to choose which members of structs or unions 
are displayed, as well as their formats.
.LI "Journal"
Keeps a log of recent changes in the state of
the program, such as hitting breakpoints and tracepoints,
and stepping statements and instructions.
.LI "Signals"
Allows you to send a Unix signal to the process,
and to select the signals that will be intercepted by the debugger
when they are delivered to the process.
.LI "Breakpoint"
Lists the current breakpoints in the program.
Menu entries allow them to be cleared individually, or all at once.
.LE
.P
While all of the windows for a process are accessible from the Process window,
there are many different traversal paths between them.
For example, a Frame window may be opened from the Process window,
a Source Text window, the Assembler window, or another Frame window. 
.P
In typical debugging sessions,
only a small fraction of the windows that may potentially
exist for a process are ever opened.
In simple debugging sessions only three windows are usually needed:
a Process window, a Source Text window, and a Frame window.
.H 2 "Help Conventions"
To allow you to find quickly the description of a window's contents, menus, 
and keyboard operators, each window chapter has the following sections:
.DS I N
1. Window Overview
2. Window Layout
3. Menu Bar
4. Window Keyboard Language
5. Line Menus
6. Line Keyboard Languages
.DE
.P
Sections may be missing if a window does not support a feature, such as
line menus.
.P
The following conventions are used to present the keyboard languages.
`|' represents the or operator, and indicates either the item on
the left or right of the `|' may be used.
Optional items are enclosed in  "[]" brackets and a 
variable number of items are represented by "...".
For example,
.DS I N
!program [arg1 ...]
.DE
.P
indicates you must type the character `!',
followed by the file name of a program,
optionally followed by one or more arguments.
Similarly,
.DS I N
C_expression | ?string
.DE
.P
indicates either a C expression or a `?` character followed
by a string is required.
.H 2 "Definitions"
.VL 12 1
.LI "activation record"
.br
The area of memory on the stack that contains the local variables,
arguments, and saved registers for a function.
Each active function has its own activation record.
.LI "breakpoint"
A breakpoint causes a process to stop when the program counter
reaches a specified address.
Breakpoints are implemented by replacing the original instruction
at the address with special code that traps into the Unix kernel
and suspends the process.
Hitting a breakpoint selects the source statement or assembly
instruction where the breakpoint was set.
.LI "callstack"
All the activation records on the stack.
.LI "conditional breakpoint"
.br
A special type of breakpoint that when hit, evaluates a C expression
and either stops the process or automatically resumes it depending
on whether the expression is true or false.
When a conditional breakpoint is hit the source
statement or assembly instruction where the breakpoint was set is selected
and the value of the evaluated expression is displayed.
If multiple conditional breakpoints are set and their conditions are false,
they flash in sequence as they are hit,
providing a crude form of algorithm animation.
.LI "core dump"
A core dump is a file, usually named core,
that contains the memory image of a program's data segment,
stack segment, and registers.
A core dump is created by the operating system
when certain signals are sent to a process and the process does
not provide signal handlers.
Most core dumps are created by software bugs that cause
detectable hardware errors, such as bus errors.
.LI "hang"
A Unix program provided with the debugger software that
starts a program and suspends it before the first instruction is executed.
The debugger may then attach to the program, providing a
mechanism to debug the first instructions of program started
from outside the debugger.
.LI "instruction"
A machine (assembly level) instruction.
Stepping the processor one instruction executes one machine instruction.
.LI "lvalue"
A C expression that refers to a manipulatable region of storage.
A C expression that may legally be placed on the left side of an
assignment statement is a lvalue expression.
If it makes sense to take the address of an expression with the `&' operator,
than the expression is a lvalue.
.LI "open a window"
.br
In the discussion of many of the operators the phrase "open a window" is used.
For example, choosing the "Globals" menu entry opens the Globals window.
In this context, opening the window means if the window has not been 
previously opened, it will be placed on the screen.
If the window has already been created, opening the window
brings it to the top of the window hierarchy, fully exposing it.
.LI "spy"
A C expression that is evaluated every time the process stops.
If a process is running, spy expressions are evaluated once a second.
A spy expression that changes at a conditional breakpoint or while
instruction or statement stepping causes the process to be suspended.
.LI "stack frame"
Another name for an activation record.
.LI "statement"
The code implementing a C or C++ statement.
Stepping the processor one statement
will execute all the instructions corresponding to that statement.
.LI "tracepoint"
A special type of conditional breakpoint,
where the evaluated condition is 0, and thus always false.
When a tracepoint is hit the source statement or assembly instruction
where the tracepoint was set is selected.
If multiple tracepoints are set, they
flash in sequence as they are hit,
providing a crude form of algorithm animation. 
.LE
